<?php
// Database connection details
$servername = "localhost";
$username = "uzx1egl6mvonn";
$password = "wfcdg8d9esqn";
$dbname = "dbpwyq3swetihg";

// Set timezone to Asia/Kolkata
date_default_timezone_set('Asia/Kolkata');

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Initialize variables
$patient_name = $mobile_number = $pincode = $state = $city = $clinic_id = $clinic_name = $appointment_date = $appointment_time = $consultation_type = "";
$utm_source = $utm_medium = $utm_campaign = $utm_adgroup = "";
$duplicate_error = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Capture form data
    $patient_name = $_POST['patient_name'] ?? '';
    $mobile_number = $_POST['mobile_number'] ?? '';
    $pincode = $_POST['pincode'] ?? '';
    $state = $_POST['state'] ?? '';
    $city = $_POST['city'] ?? '';
    $clinic_id = $_POST['clinic_id'] ?? '';
    $appointment_date = $_POST['appointment_date'] ?? '';
    $appointment_time = $_POST['appointment_time'] ?? '';
    $consultation_type = $_POST['consultation_type'] ?? '';
    
    // Capture UTM parameters
    $utm_source = $_POST['utm_source'] ?? '';
    $utm_medium = $_POST['utm_medium'] ?? '';
    $utm_campaign = $_POST['utm_campaign'] ?? '';
    $utm_adgroup = $_POST['utm_adgroup'] ?? '';

    // Convert appointment date to dd/mm/yyyy format
    $datetime = DateTime::createFromFormat('Y-m-d', $appointment_date);
    if ($datetime) {
        $appointment_date = $datetime->format('d/m/Y');
    }

    // Fetch clinic name if not "other"
    if ($clinic_id === "other") {
        $clinic_name = "Other";
    } else {
        $stmt = $conn->prepare("SELECT clinic_names FROM clinicslistwithstateandcity WHERE id = ?");
        $stmt->bind_param("i", $clinic_id);
        $stmt->execute();
        $stmt->bind_result($clinic_name);
        if (!$stmt->fetch()) {
            die("Error: Invalid clinic ID.");
        }
        $stmt->close();
    }

    // Define conversion values for consultation types
    $conversion_values = [
        "Diabetes Consultation" => 220,
        "Heart Disease Consultation" => 282,
        "High BP / Hypertension Consultation" => 188,
        "Weight Loss Consultation" => 188,
        "Other Disease Consultation" => 94
    ];

    $conversion_value = $conversion_values[$consultation_type] ?? 94;

    // Check for duplicate appointment
    $check_stmt = $conn->prepare("SELECT id FROM diabetescareappointments WHERE patient_name = ? AND mobile_number = ?");
    $check_stmt->bind_param("ss", $patient_name, $mobile_number);
    $check_stmt->execute();
    $check_stmt->store_result();
    
    if ($check_stmt->num_rows > 0) {
        $duplicate_error = true;
    }
    $check_stmt->close();

    if (!$duplicate_error) {
        // Get current date-time in required format (dd/mm/yyyy hh:mm:ss)
        $created_at = date("d/m/Y H:i:s");

        // Insert data into the table
        $insert_stmt = $conn->prepare("INSERT INTO diabetescareappointments 
            (patient_name, mobile_number, pincode, state, city, clinic_name, appointment_date, appointment_time, consultation_type, created_at, utm_source, utm_medium, utm_campaign, utm_adgroup, conversion_value) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $insert_stmt->bind_param("sssssssssssssss", 
            $patient_name, $mobile_number, $pincode, $state, $city, $clinic_name, 
            $appointment_date, $appointment_time, $consultation_type, $created_at, 
            $utm_source, $utm_medium, $utm_campaign, $utm_adgroup, $conversion_value);

        if (!$insert_stmt->execute()) {
            die("Error: " . $insert_stmt->error);
        }
        $insert_stmt->close();
    }
}

$conn->close();
?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/owl.theme.default.min.css">
    <link rel="stylesheet" href="css/owl.carousel.min.css">
    <link rel="stylesheet" href="css/style-2.css">
    <title>Thank You - Madhavbaug</title>
    <style>
        ul li {
            margin-bottom: 10px;
            font-size: 14px;
        }

        main {
            min-height: 100vh;
        }

        footer {
            bottom: 0 !important;
        }
    </style>
	
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-MVW2KBC3V1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-MVW2KBC3V1');
</script>
    
	<!-- Event snippet for Appointment_MM conversion page -->
<script>
      gtag('event', 'conversion', {
          'send_to': 'AW-843953390/hn8zCNzkpqcaEO7ptpID',
          'value': <?php echo $conversion_value; ?>,
          'currency': 'INR'
      });
    </script>
	
	

	
</head>

<body>
    <main>
        <section>
            <div class="container py-4">
                <p class="header-logo-style text-center pb-4"><img src="img/madhavbaug_logo_l.png" class="img-fluid"></p>
                <h1 class="fs-1 fw-bold text-lgr text-center">
                    Welcome to the <span class="fs-1">Madhavbaug</span>
                </h1>
                <p class="text-center fs-5">Thank you for booking your appointment.<br><br>
Our clinic representative will call you soon to guide you through the next steps. Once ready, you can visit your nearest Madhavbaug clinic to pay the discounted amount and activate your services. Together, we’re building a stronger, healthier community with heart health at its core.<br><br>
We’re honored to have you on this meaningful journey. Let’s take the next step toward a healthier tomorrow—together!
</p>
                <!--<h2 class="text-prime fs-3 fw-bold text-center mt-5 line-height-new">Here’s how to redeem your Madhavbaug Hriday Sangini Care Program Coupon.</h2>-->
                
                
                
            </div>
        </section>
    </main>
    <footer>
        <p class="text-center text-white m-0 p-3">2025 Madhavbaug. All Rights Reserved</p>
    </footer>
    <div id="google_translate_element" class="d-none"></div>
    <script src="js/jquery-3.7.1.min.js"></script>
    <script src="js/match-height.min.js"></script>
    <script src="js/owl.carousel.min.js"></script>
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({
                pageLanguage: 'en',
                layout: google.translate.TranslateElement.InlineLayout.SIMPLE
            }, 'google_translate_element');
        }

        function toggleTranslate() {
            $('.goog-te-gadget-simple').click();
        }

        $(window).on('scroll', function () {
            if ($(this).scrollTop() > 30) {
                $('header').removeClass('top');
            } else {
                $('header').addClass('top');
            }
        });
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
</body>

</html>
