<?php

session_start(); // Start session to store UTM parameters

// Capture UTM parameters and store them in session
if (isset($_GET['utm_source'])) {
    $_SESSION['utm_source'] = $_GET['utm_source'];
}
if (isset($_GET['utm_medium'])) {
    $_SESSION['utm_medium'] = $_GET['utm_medium'];
}
if (isset($_GET['utm_campaign'])) {
    $_SESSION['utm_campaign'] = $_GET['utm_campaign'];
}
if (isset($_GET['utm_adgroup'])) {
    $_SESSION['utm_adgroup'] = $_GET['utm_adgroup'];
}

?>

<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="keywords" content="">
    <meta name="description" content="">

    <title>Madhavbaug</title>
    
    <!-- Loading Bootstrap -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Loading Template CSS -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link 
		href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&display=swap" rel="stylesheet" media="print" onload="this.media='all'">
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500&display=swap" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
	<link href="css/home.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link rel="stylesheet" href="css/pe-icon-7-stroke.css">
    <link href="css/style-magnific-popup.css" rel="stylesheet">
	<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


    <!-- Awsome Fonts -->
    <link rel="stylesheet" href="css/all.min.css">
	

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,400;0,700;1,400&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Slab:wght@600&display=swap" rel="stylesheet">

    <!-- Font Favicon -->
    <link rel="shortcut icon" href="img/icon-mb.png">
	
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-MVW2KBC3V1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-MVW2KBC3V1');
</script>

    
</head>

<body>

    <!--begin home section -->
    <section class="home-section" id="home" style="padding-top:10px;">

        <div class="home-section-overlay"></div>

		<!--begin container -->
		<div class="container">

	        <!--begin row -->
	        <div class="row">
	          
                <!--begin col-md-6-->
                <div class="col-md-4 margin-top-20 main-logo-css">

                    <div style="margin-bottom:20px;"><img src="img/madhavbaug_logo_l.png" class="img-fluid img-responsive home-image" /></div>
					<h1 style="margin-top: 41px;">Going beyond management<br> <span style="color:#90343a;">to Reverse</span>
diabetes<br><span style="color:#90343a;">at the root. </span></h1>
<p class="hero-text">We’ve seen 57% reduction in<br>number of patients  taking<br>allopathic medications after<br>12 weeks.<sup>1<sup>
</p>


                    <p class="hero-text1">Want to know about reversing your disease?</p>

                   <h1 class="headermobile" style="color:#90343a;margin-top: -18px;">Book your consultation today.</h1>
					
					<p class="desktoptext">1. Sane R, Mandole R, Amin GA, Ghadigaokar P, Paranjape S. Effectiveness of Comprehensive Diabetes Care (CDC) in Diabetic Patients: an Observational Study. International Journal of Innovative Research in Medical Science (IJIRMS). 2020 Aug;5(08).</p>
					<!-- <p class="hero-text2">1. Data on file.</p> -->
                   <p class="mobiletext" style="font-family: 'DINCond-Regular', sans-serif;">1. Sane R, Mandole R, Amin GA, Ghadigaokar P, Paranjape S. Effectiveness of Comprehensive Diabetes Care (CDC) in Diabetic Patients: an Observational Study. International Journal of Innovative Research in Medical Science (IJIRMS). 2020 Aug;5(08).</p>
                </div>
				<div class="col-md-3 image-container">

                    <div class="image-container"><img src="img/main-cover-main-heart-banner.png" class="img-fluid heartimage" /></div>
					
        
                </div>
                <!--end col-md-6-->

                <!--begin col-md-5-->
                <div class="col-md-5 margin-top-20">
				
    <!--begin register-form-wrapper-->
    
	<div id="main-cta-form">
					
					<form method="post" action="thankyou.php" id="appointmentForm" class="appointment_form">
    <h3>Book Your Appointment Now</h3>

    <div class="form-group">
        <label for="patient_name">Name:</label>
        <input type="text" name="patient_name" id="patient_name" required placeholder="Enter your full name">
    </div>

    <div class="form-group">
        <label for="mobile_number">Mobile Number:</label>
        <input type="text" name="mobile_number" id="mobile_number" required pattern="^\d{10}$" 
               title="Enter a valid 10-digit mobile number" placeholder="Enter your 10-digit mobile number">
    </div>

    <div class="form-group">
        <label for="pincode">Pincode:</label>
        <input type="text" name="pincode" id="pincode" required pattern="^\d{6}$" 
               title="Enter a valid 6-digit pincode" placeholder="Enter your 6-digit pincode">
    </div>

    <div class="form-group">
        <label for="state">State:</label>
        <select name="state" id="state">
            <option value="">Select State</option>
        </select>
    </div>

    <div class="form-group">
        <label for="city">City:</label>
        <select name="city" id="city" disabled>
            <option value="">Select City</option>
        </select>
    </div>

    <div class="form-group">
        <label for="clinic">Clinic:</label>
        <select name="clinic_id" id="clinic" disabled>
            <option value="">Select Clinic</option>
        </select>
    </div>

    <div class="form-group">
        <label for="appointment_date">Date:</label>
        <input type="text" name="appointment_date" id="appointment_date" required placeholder="Select your appointment date">
    </div>

    <div class="form-group">
        <label for="appointment_time">Time:</label>
        <select name="appointment_time" id="appointment_time" required>
            <option value="">Select Time</option>
            <option value="10:30AM to 11:00AM">10:30AM to 11:00AM</option>
            <option value="11:00AM to 12:00PM">11:00AM to 12:00PM</option>
            <option value="12:00PM to 01:00PM">12:00PM to 01:00PM</option>
            <option value="01:00PM to 02:00PM">01:00PM to 02:00PM</option>
            <option value="02:00PM to 03:00PM">02:00PM to 03:00PM</option>
            <option value="03:00PM to 04:00PM">03:00PM to 04:00PM</option>
            <option value="04:00PM to 05:00PM">04:00PM to 05:00PM</option>
            <option value="05:00PM to 06:00PM">05:00PM to 06:00PM</option>
        </select>
    </div>

    <div class="form-group">
        <label for="consultation_type">Consultation for:</label>
        <select name="consultation_type" id="consultation_type" required>
            <option value="">Select Consultation Type</option>
            <option value="Diabetes Consultation">Diabetes Consultation</option>
            <option value="Heart Disease Consultation">Heart Disease Consultation</option>
            <option value="High BP / Hypertension Consultation">High BP / Hypertension Consultation</option>
            <option value="Weight Loss Consultation">Weight Loss Consultation</option>
            <option value="Other Disease Consultation">Other Disease Consultation</option>
        </select>
    </div>
	<!-- Hidden UTM Fields -->
    <input type="hidden" name="utm_source" value="<?php echo isset($_SESSION['utm_source']) ? $_SESSION['utm_source'] : ''; ?>">
    <input type="hidden" name="utm_medium" value="<?php echo isset($_SESSION['utm_medium']) ? $_SESSION['utm_medium'] : ''; ?>">
    <input type="hidden" name="utm_campaign" value="<?php echo isset($_SESSION['utm_campaign']) ? $_SESSION['utm_campaign'] : ''; ?>">
    <input type="hidden" name="utm_adgroup" value="<?php echo isset($_SESSION['utm_adgroup']) ? $_SESSION['utm_adgroup'] : ''; ?>">
    <input type="submit" value="Book Appointment">
</form>
					
					</div>
	
	
	
	
	
	
	
	
	
	
	
	
	
    <!--end register-form-wrapper-->
</div>



				
				
				
                <!--end col-md-5-->

	        </div>
	        <!--end row -->

		</div>
		<!--end container -->

    </section>
    <!--end home section -->
	
	<section class="section-white-bg" id="about">

        <!--begin container -->
        <div class="container">

            <!--begin row -->
            <div class="row">

                <!--begin col-md-12 -->
                <div class="col-md-7">

                    <h1>Madhavbaug - Expert Consultation with<br> Modern Diagnostics</h1>
					<p class="section-subtitle mobile-carousel">To effectively address diabetes, it's important to find out <br>why it happened in the first place. Once we know the root <br>cause, we can create an ayurvedic treatment plan to <br> help reverse it. This helps in better and longer-lasting <br>recovery. We’ve successfully helped patients lead a life<br> free from the worries of diabetes, through our network <br> of over 360 clinics.</p>
					
					<p class="section-subtitle desktop-carousel">To effectively address diabetes, it's important to find out why it happened in the first place. Once we know the root cause, we can create an ayurvedic treatment plan to help reverse it. This helps in better and longer-lasting recovery. We’ve successfully helped patients lead a life free from the worries of diabetes, through our network  of over 360 clinics.</p>
					
					<!-- <p style="color:#902e2b;">Watch the video to take a virtual tour of Madhavbaug.</p> -->
					
                    
                </div>
				
				<div class="col-md-5">

                    <div style="position: relative; padding-bottom: 56.25%; height: 0; overflow: hidden; max-width: 100%; background: #000;">
    <iframe 
        src="https://player.vimeo.com/video/657349115" 
        frameborder="0" 
        allow="autoplay; fullscreen; picture-in-picture" 
        allowfullscreen 
        style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;" 
        title="Madhavbaug Legacy Video">
    </iframe>
</div>

<script src="https://player.vimeo.com/api/player.js"></script>
                <!--end col-md-12 -->

            </div>
            <!--end row -->

        </div>
        <!--end container -->

        

    </section>
	
	
	<section class="section-grey">
        
        <!--begin container-->
        <div class="container">
		
		<!--begin row -->
            <div class="row">

                <!--begin col-md-12 -->
                <div class="col-md-12 text-center margin-bottom-10">

                    <h2 class="section-title-white">Assessment Includes</h2>
                    
                </div>
                <!--end col-md-12 -->

            </div>
            <!--end row -->

            <!--begin row-->
            <div class="row align-items-start white-shape-bg">
    <div class="col-md-3">
        <div class="d-flex flex-column align-items-center">
            <p class="consultation-img"><img src="img/clinic-doctor-consultation.jpg" class="img-fluid" /></p>
            <h5 class="consultation-image-caption">Expert<br>Doctor Consultation</h5>
        </div>
    </div>
    <div class="col-md-3">
        <div class="d-flex flex-column align-items-center">
            <p class="consultation-img"><img src="img/computerized-cardiac-stress-test.jpg" class="img-fluid" /></p>
            <h5 class="consultation-image-caption">ECG<br>(Electrocardiogram) </h5>
        </div>
    </div>
    <div class="col-md-3">
        <div class="d-flex flex-column align-items-center">
            <p class="consultation-img"><img src="img/BST.png" class="img-fluid" /></p>
            <h5 class="consultation-image-caption">RBS<br>(Random Blood Sugar)</h5>
        </div>
    </div>
    <div class="col-md-3">
        <div class="d-flex flex-column align-items-center">
            <p class="consultation-img"><img src="img/personalconsult.png" class="img-fluid" /></p>
            <h5 class="consultation-image-caption">Physical Examination</h5>
        </div>
    </div>
	<div class="col-md-3">
        <div class="d-flex flex-column align-items-center">
            <p class="consultation-img"><img src="img/SP02.png" class="img-fluid" /></p>
            <h5 class="consultation-image-caption">SpO2</h5>
        </div>
    </div>
	<div class="col-md-3">
        <div class="d-flex flex-column align-items-center">
            <p class="consultation-img"><img src="img/cardiac-risk-assessment.jpg" class="img-fluid" /></p>
            <h5 class="consultation-image-caption">Blood Pressure Test</h5>
        </div>
    </div>
	<div class="col-md-3">
        <div class="d-flex flex-column align-items-center">
            <p class="consultation-img"><img src="img/BMI.png" class="img-fluid" /></p>
            <h5 class="consultation-image-caption">BMI</h5>
        </div>
    </div>
	<div class="col-md-3">
        <div class="d-flex flex-column align-items-center">
            <p class="consultation-img"><img src="img/clinic-diet-plan.jpg" class="img-fluid" /></p>
            <h5 class="consultation-image-caption">Diet Chart</h5>
        </div>
    </div>
</div>



            <!--end row-->
    
        </div>
        <!--end container-->
    
    </section>
	
	<section class="section-white-bg" id="about">

        <!--begin container -->
        <div class="container">
		
		<div class="slider-border">
		
			<div class="row">

                <!--begin col-md-12 -->
                <div class="col-md-12 text-center margin-bottom-10">

                    <h2 class="section-title-white-in-blue-bg title-blue-bg">Recommended for Patients</h2>
                    
                </div>
                <!--end col-md-12 -->

            </div>
            <!--end row -->

            <!--begin row -->
            <div class="row list-padding">
    <div class="col-md-6 mx-auto">
        <ul class="icon-list">
            <li>Taking Excessive Insulin Dosage & Diabetes Medicine</li>
            <li>Suffering from Type 2 Diabetes</li>
            <li>Uncontrolled Blood Sugar (even if on medication)</li>
            <li>Excessive Tiredness / Blurry Vision</li>
            <li>Slow-Healing Wounds / Frequent Infections</li>
        </ul>
    </div>
    <div class="col-md-6 mx-auto">
        <ul class="icon-list">
            <li>Insomnia</li>
            <li>Excessive Thirst / Frequent Urination</li>
            <li>Numbness, Tingling and Pain in Hands / Feet</li>
            <li>Fatigue & Stress</li>
            <li>Neuropathy & Nephropathy Problems</li>
        </ul>
    </div>
</div>

            <!--end row -->
		
		</div>
		
        </div>
        <!--end container -->
		
		

        

    </section>
	
	 <!--begin partners-section-->
    <div class="partners-section">
        
        <!--begin container-->
        <div class="container">
		
		<!--begin row -->
            <div class="row">

                <!--begin col-md-12 -->
                <div class="col-md-12 text-center margin-bottom-70">

                    <h3 class="service-section-h3-title">What Our Patients Experienced</h3>
					
                    
                </div>
                <!--end col-md-12 -->

            </div>
            <!--end row -->
			
			<div class="row">
			
				

                <!--begin col-md-12 -->
                <div class="col-md-4 text-center">

                 <p class="counter-numbers">90<span class="counter-numbers-percent">%</span></p>
				 <p class="counter-numbers-captions">reported decreased<br>blood sugar levels</p>
					
                    
                </div>
				
				<div class="col-md-4 text-center">

                 <p class="counter-numbers">95<span class="counter-numbers-percent">%</span></p>
				 <p class="counter-numbers-captions">were completely rid of<br>diabetes-related symptoms</p>   
					
                    
                </div>
				
				<div class="col-md-4 text-center">

                 <p class="counter-numbers">75<span class="counter-numbers-percent">%</span></p>
				 <p class="counter-numbers-captions">stopped their medication<br>in 120 days</p>
					
                    
                </div>
                <!--end col-md-12 -->
				
				

            </div>


			<div class="row">

                <!--begin col-md-12 -->
                <div class="col-md-12 text-center">

                    <h3 class="counters-red-rounded-bg">Resulting In 40,000+ Lives Transformed</h3>
					
                    
                </div>
                <!--end col-md-12 -->

            </div>
			
			<div class="row">

                <!--begin col-md-12 -->
                <div class="col-md-12 text-center">

                    <p class="all-patients-image"><img src="img/all-patients.png" class="img-fluid" /></p>
					
                    
                </div>
                <!--end col-md-12 -->

            </div>
            
			
			
			
			
			
			
			
			
            
        </div>
        <!--end container-->
    
    </div> 
    <!--end partners-section-->
	

   

    <!--begin section-white -->
    <section class="section-white" id="about">

        <!--begin container -->
        <div class="container">

            <!--begin row -->
            <div class="row">

                <!--begin col-md-12 -->
                <div class="col-md-12 text-center margin-bottom-10">

                    <h4 style="color:#000;">Recognised by 150+ Global Publications & Research Journals</h4>
                    
                </div>
                <!--end col-md-12 -->

            </div>
            <!--end row -->

        </div>
        <!--end container -->
		

        <!--begin services-wrapper -->
        <div class="services-wrapper">

            <!--begin container -->
            <div class="container">

                <!--begin row -->
                <div class="row">

                    <!--begin col-md-4 -->
                    <div class="col-md-3">

                            <p><img src="img/thelancet.jpg" class="img-fluid" /></p>

                    </div>
                    <!--end col-md-4 -->

                    <!--begin col-md-4 -->
                    <div class="col-md-3">

                            <p><img src="img/ihj.jpg" class="img-fluid" /></p>

                    </div>
                    <!--end col-md-4 -->

                    <!--begin col-md-4 -->
                    <div class="col-md-3">

                            <p><img src="img/ajcc.jpg" class="img-fluid" /></p>

                    </div>
                    <!--end col-md-4 -->
					
					<div class="col-md-3">

                            <p><img src="img/british.jpg" class="img-fluid" /></p>

                    </div>
               
                </div>
                <!--end row -->
				
				<div class="row">

                <!--begin col-md-12 -->
                <div class="col-md-12 text-center margin-bottom-10">

                    <hr>
                    
                </div>
                <!--end col-md-12 -->

            </div>
			
			
			
                
            </div>
            <!--end container -->
			
			
			<div class="container">
		
		
		
			<div class="row">

                <!--begin col-md-12 -->
                <div class="col-md-12 text-center margin-bottom-10">

                    <h2 class="section-title-white-in-blue-bg title-blue-bg">Our Patients and their Results</h2>
                    
                </div>
				<div class="col-md-4">
       
            <!-- <iframe width="480" height="270" src="https://www.youtube.com/embed/0UVEMeP8NUE" frameborder="0" allowfullscreen></iframe>  -->
			<iframe width="560" height="270" src="https://www.youtube.com/embed/kTHWutE2HWw?si=eg_VAsiI-LxYtUeG"  frameborder="0" allowfullscreen></iframe>
            
        
    </div>
	<div class="col-md-4">
       
            <iframe width="560" height="270" src="https://www.youtube.com/embed/ps6TripiGeM?si=TrKYDGSE6MMI9cOq"  frameborder="0"  allowfullscreen></iframe>
           
        
    </div>
	<div class="col-md-4">
       
            <iframe width="560" height="270" src="https://www.youtube.com/embed/BxnEv4sTE08?si=lQeFjSz8FXpoKxZH"  frameborder="0"  allowfullscreen></iframe>
            
        
    </div>
				
              

            </div>
           
		 </div>
		
		<!-- End Container -->
		
		
		
		<div class="container" style="margin-top: 55px;">
		<div class="row">

                    <!--begin col-md-4 -->
                    <div class="col-md-6">
							<h4 style="color:#000; text-align:center;font-family: 'DINCond-Bold',sans-serif;">Madhavbaug hospital (Khopoli)<br>is NABH accredited</h4>
                            <p style="text-align:center;"><img src="img/logofot1.png" class="img-fluid" /></p>

                    </div>
                    <!--end col-md-4 -->

                    <!--begin col-md-4 -->
                    <div class="col-md-6">
							<h4 style="color:#000; text-align:center;font-family: 'DINCond-Bold',sans-serif;">We accept SBI Cashless Health Insurance for heart & diabetes treatment</h4>
                            <p style="text-align:center;"><img src="img/logofot2.png" class="img-fluid" /></p>

                    </div>
                    <!--end col-md-4 -->

                    
               
                </div>
                
            </div>
			
			

        </div>
        <!--end services-wrapper -->

    </section>
    <!--end section-white -->
	
	
	
	
	
	


    <!--begin footer -->
    <div class="footer">
            
        <!--begin container -->
        <div class="container">
        
            <!--begin row -->
            <div class="row">
            
                <!--begin col-md-12 -->
                <div class="col-md-12">
                   
                    <p>© 2025 <a href="https://madhavbaug.org/" target="_blank">Madhavbaug</a>. All Rights Reserved.</p>
                    
                </div>
                <!--end col-md-12 -->
                
                
                
                
                
            </div>
            <!--end row -->

        </div>
        <!--end container -->
               
    </div>
    <!--end footer -->


<!-- Load JS here for greater good =============================-->
<!--<script src="js/jquery-3.3.1.min.js"></script>-->
<script src="js/bootstrap.min.js"></script>
<script src="js/jquery.scrollTo-min.js"></script>
<!--<script src="js/jquery.magnific-popup.min.js"></script>-->
<script src="js/jquery.nav.js"></script>
<script src="js/wow.js"></script>
<script src="js/plugins.js"></script>
<script src="js/custom.js"></script>
<script src="js/location.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="js/match-height.min.js"></script>

<script>
    $(document).ready(function () {
        // Fetch states on page load
        $.ajax({
            url: 'fetch_clinic.php',
            type: 'POST',
            data: { action: 'fetch_states' },
            dataType: 'json',
            success: function (data) {
                $('#state').append(data.states); // Populate states dropdown
            }
        });

        // Fetch cities based on state selection
        $('#state').on('change', function () {
            var state = $(this).val();
            $('#city').prop('disabled', state === "");
            $('#clinic').prop('disabled', true).html("<option value=''>Select Clinic</option>");

            // Reset city dropdown
            $('#city').html("<option value=''>Select City</option>");

            if (state) {
                if (state === 'other') {
                    $('#city').prop('disabled', false).html("<option value='other'>Other</option>");
                    $('#clinic').prop('disabled', false).html("<option value='other'>Other</option>");
                } else {
                    $.ajax({
                        url: 'fetch_clinic.php',
                        type: 'POST',
                        data: { action: 'fetch_cities', state: state },
                        dataType: 'json',
                        success: function (data) {
                            $('#city').html(data.cities); // Populate city dropdown

                            // Automatically select city if there is only one
                            if ($('#city option').length === 2) {  // Only one city
                                var city = $('#city option').eq(1).val();  // Get the single city
                                $('#city').val(city);  // Select that city
                                $('#city').trigger('change');  // Trigger the change event
                            }
                        }
                    });
                }
            } else {
                $('#clinic').prop('disabled', true).html("<option value=''>Select Clinic</option>");
            }
        });

        // Fetch clinics based on city selection
        $('#city').on('change', function () {
            var city = $(this).val();
            $('#clinic').prop('disabled', city === "");

            // Reset clinic dropdown
            $('#clinic').html("<option value=''>Select Clinic</option>");

            if (city) {
                if (city === 'other') {
                    $('#clinic').html("<option value='other'>Other</option>");
                } else {
                    $.ajax({
                        url: 'fetch_clinic.php',
                        type: 'POST',
                        data: { action: 'fetch_clinics', city: city },
                        dataType: 'json',
                        success: function (data) {
                            $('#clinic').html(data.clinics); // Populate clinic dropdown

                            // Automatically select clinic if there is only one
                            if ($('#clinic option').length === 2) {  // Only one clinic
                                var clinic = $('#clinic option').eq(1).val();  // Get the single clinic
                                $('#clinic').val(clinic);  // Select that clinic
                            }
                        }
                    });
                }
            }
        });

        // Date Picker setup: Disable Thursdays and set a 2-day buffer, and limit up to 14 days from current date
        var today = new Date();
        today.setDate(today.getDate() + 2); // Add 2 days buffer
        var minDate = today.toISOString().split('T')[0]; // Format as yyyy-mm-dd

        // Set the maximum date (14 days from today)
        var maxDate = new Date();
        maxDate.setDate(maxDate.getDate() + 15); // Add 14 days buffer
        var maxDateStr = maxDate.toISOString().split('T')[0]; // Format as yyyy-mm-dd

        function disableThursdays(date) {
            var day = date.getDay(); // Get day of the week (0=Sunday, 1=Monday, ..., 4=Thursday)
            var dayString = date.toISOString().split('T')[0]; // Format date as yyyy-mm-dd

            if (day == 4 || dayString < minDate) {
                return [false]; // Disable Thursdays and dates before the buffer
            } else {
                return [true]; // Enable other days
            }
        }

        $("#appointment_date").datepicker({
            minDate: minDate, // Set minimum selectable date (2 days buffer)
            maxDate: maxDateStr, // Set maximum selectable date (14 days from today)
            beforeShowDay: disableThursdays, // Disable Thursdays
            dateFormat: 'yy-mm-dd' // Date format
        });
    });
</script>


 
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>


</body>
</html>